<?php

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
ob_start();
error_reporting(0);
session_start();
//PATH
define('ABSPATH', dirname(dirname(__FILE__)) . '/');
define('PF_VERSION','1.0');
$relative_path = dirname(substr($_SERVER['SCRIPT_NAME'], 0, strrpos($_SERVER['SCRIPT_NAME'], '/')));
define('RELATIVE_PATH', (strlen($relative_path) > 1 ? $relative_path : ''));
define('ASSET_PATH', RELATIVE_PATH . '/admin/themes/default/assets/');
// Charset and Collection
define('DB_CHARSET', 'utf8');
define('DB_COLLATE', 'utf8_general_ci');
require ABSPATH . 'installs/includes/functions.php';
//Requie default
require ABSPATH . '/includes/pf-class.php';
require ABSPATH . '/includes/security-class.php';
require ABSPATH . '/includes/File_Gettext/File/Gettext.php';
require ABSPATH . '/includes/File_Gettext/File/Gettext/MO.php';
require ABSPATH . '/includes/File_Gettext/File/Gettext/PO.php';
require ABSPATH . '/includes/helper/l10n-helper.php';
$step = isset($_GET['step']) ? (int) $_GET['step'] : 1;
$template_path = ABSPATH . 'installs/templates/';

// Check the web has been installed or not
if (pf_check_install() && $step !== 3) {
    pf_get_header();
    require $template_path . 'installed.php';
    pf_get_footer();
    exit();
}
$heading = array(1 => 'Welcome', 2 => 'Database and Site Settings', 3 => 'Finish');
pf_get_header();
switch ($step) {
    case 1:
        require $template_path . 'step1.php';
        break;
    case 2:
        $type = 'danger';
        $message = '';
        $config_file = ABSPATH . 'configs/config-sample.php';
        $sql_file = ABSPATH . 'installs/data/pageflex.sql';

        if (!pf_check_exists_config()) {
            $message[] = 'Could not find config-sample.php file in the config directory.';
        } elseif (!is_writable(ABSPATH . 'configs')) {
            $message[] = 'We cannot create file config.php to you are.';
        } elseif (!is_readable(ABSPATH . 'configs/config-sample.php')) {
            $message[] = 'We do not read the file config-sample.php.';
        }
        if (!is_writable(ABSPATH . 'uploads')) {
            $message[] = 'uploads directory must have write permissions.';
        }
        if (!is_writable(ABSPATH . 'tmp')) {
            $message[] = 'tmp directory must have write permissions.';
        }

        if (!pf_check_exists_sql()) {
            $message[] = 'Could not find pageflex.sql file in the data directory.';
        } elseif (!is_readable($sql_file)) {
            $message[] = 'We do not read the file pagefile.sql. You Please check permission to execute.';
        }

        if (!empty($message)) {
            require $template_path . 'missing-file.php';
            pf_get_footer();
            break;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $errors = array();
            require ABSPATH . 'installs/includes/validator.php';
            if (empty($errors)) {
                $errors = array();
                define('DB_NAME', value_input('database'));
                define('DB_USER', value_input('user'));
                define('DB_PASSWORD', value_input('pwd'));
                define('DB_HOST', value_input('host'));
                $link = mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
                mysqli_query($link, 'SET NAMES ' . DB_CHARSET . ' COLLATE ' . DB_COLLATE);

                if (mysqli_connect_errno()) {
                    $message = mysqli_connect_error();
                    $type = 'danger';
                } else {
                    // Security
                    $security = new Pf_Security;
                    define('__SECURITY_SALT__', $security->genrandom(40));
                    define('__SECURITY_CIPHER_SEED__', $security->genrandom(29, '0123456789'));

                    // Config file
                    $config_file = file($config_file);
                    foreach ($config_file as $line_num => $line) {
                        if (!preg_match('/^define\(\'([A-Z_]+)\'/', $line, $match)) {
                            continue;
                        }
                        $name = $match[1];
                        if (in_array($name, array('DB_NAME', 'DB_USER', 'DB_PASSWORD', 'DB_HOST', '__SECURITY_SALT__', '__SECURITY_CIPHER_SEED__'))) {
                            $config_file[$line_num] = "define('" . $name . "', '" . addcslashes(constant($name), "\\'") . "');\r\n";
                        }
                    }
                    unset($line);

                    //Write file config
                    $config_file_write = ABSPATH . 'configs/config.php';
                    $handle = fopen($config_file_write, 'w+');
                    if ($handle !== false) {
                        foreach ($config_file as $line) {
                            if (!fwrite($handle, $line)) {
                                $errors[] = 'There was an error in the recording process config.php file in configs folder';
                                break;
                            }
                        }
                        fclose($handle);
                        chmod($config_file_write, 0666);
                        // Data default
                        $lines = file($sql_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                        if (!empty($lines) && empty($errors)) {
                            $buffer = '';
                            mysqli_autocommit($link, false);
                            foreach ($lines as $line) {
                                if (substr(ltrim($line), 0, 2) == '--' || $line[0] == '#') {
                                    continue;
                                }
                                if (($line = trim($line)) == '') {
                                    continue;
                                } else if ($line[strlen($line) - 1] != ";") {
                                    $buffer .= $line;
                                    continue;
                                } else
                                if ($buffer) {
                                    $line = $buffer . $line;
                                    $buffer = '';
                                    if (!mysqli_query($link, $line)) {
                                        $errors[] = 'An error occurred during the data update. Notice: Database must be empty';
                                        break;
                                    }
                                }
                            }

                            //Rollback when errors
                            if (!empty($errors)) {
                                mysqli_rollback($link);
                            } else {
                                mysqli_commit(true);
                            }
                            mysqli_autocommit($link, true);

                            //Setting site default
                            $result = mysqli_query($link, "SELECT option_value FROM pf_options WHERE option_name='settings'");
                            if ($result) {
                                $row = mysqli_fetch_array($result, MYSQLI_NUM);
                                if (isset($row[0])) {
                                    $tmp = @unserialize($row[0]);
                                    $change_setting = fase;
                                    if (isset($tmp['general'])) {
                                        $tmp['general']['site_name'] = value_input('site_name');
                                        $tmp['general']['backup_dir'] = ABSPATH . "tmp/backup/database/";
                                        $change_setting = true;
                                    }

                                    if (isset($tmp['pf_user'])) {
                                        $tmp['pf_user']['userpage'] = 'user';
                                        $change_setting = true;
                                    }
                                    if ($change_setting === true) {
                                        $sql = "UPDATE `pf_options` set `option_value`='" . mysqli_real_escape_string($link, serialize($tmp)) . "' WHERE option_name='settings'";
                                        if (!mysqli_query($link, $sql)) {
                                            $errors[] = 'Do not update the settings information';
                                        }
                                    }
                                }
                            }

                            // Account Administrator Default
                            $sql_insert_account = "INSERT INTO `pf_users` (`user_name`, `user_displayname`, `user_password`, `user_email`, `user_role`, `user_registered_date`, `user_activation_key`, `user_activation`, `user_forgot_pass_key`, `user_login_ip`, `user_avatar`, `public_profile`, `user_delete_flag`) VALUES ";
                            $sql_insert_account  .="('" . mysqli_real_escape_string($link, value_input('username')) . "', '', '" . mysqli_real_escape_string($link, $security->hash(value_input('password'), null, true)) . "', '".mysqli_real_escape_string($link, value_input('email'))."', 1, now(), '', '1', '', '', '', '1', '0');";
                            if (!mysqli_query($link, $sql_insert_account)) {
                                $errors[] = 'Can not create default accounts.';
                            }

                            // Check Errors and Finish Install
                            if (empty($errors)) {
                                $_SESSION['install'] = 1;
                                header("Location: " . site_url("/installs?step=3"));
                                exit();
                            }
                            mysqli_query($link, 'DROP TABLE ' . list_table_drop() . ';');
                            unlink($config_file_write);
                        }
                        $message = $errors;
                    } else {
                        $message = 'We cannot create file config.php to you are. You Please check permission to execute.';
                    }
                }
            } else {
                $message = 'Please check the data field';
            }
        }
        require $template_path . 'step2.php';
        break;
    case 3:
        if (isset($_SESSION['install']) && $_SESSION['install'] == 1) {
            unset($_SESSION['install']);
            require $template_path . 'step3.php';
        } else {
            header("Location: " . site_url("/installs?step=1"));
            break;
        }
}
pf_get_footer();
